<!--
SPDX-FileCopyrightText: 2025 Thomas Kramer

SPDX-License-Identifier: CC-BY-SA-4.0
-->

# Verilog parser for Python
Lark based parser for Verilog netlists (structural Verilog without behavioral statements).
This is meant to be used to read netlists as generated by HDL logic synthesizers such as Yosys.

## Example
```python
from verilog_parser.parser import parse_verilog
ast = parse_verilog(open(verilog_file_path).read())
```

## Install

From PyPI:
```sh
pip install verilog-parser
```

From git:
```sh
pip install git+https://codeberg.org/tok/py-verilog-parser
```

From git for development:
```sh
git clone https://codeberg.org/tok/py-verilog-parser
cd py-verilog-parser
pip install --editable .
```

