/**
 * \file pappsomspp/processing/cbor/mzcbor/mzmlconvert.h
 * \date 19/11/2025
 * \author Olivier Langella
 * \brief convert mzML to mzcbor
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once

#include "pappsomspp/core/processing/uimonitor/uimonitorinterface.h"
#include "pappsomspp/core/processing/cbor/cborstreamwriter.h"
#include "pappsomspp/core/processing/xml/xmlstreamreaderinterface.h"


#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL MzmlConvert : public XmlStreamReaderInterface
{
  public:
  /**
   * Default constructor
   */
  MzmlConvert(pappso::UiMonitorInterface *p_monitor, pappso::cbor::CborStreamWriter *p_output);

  /**
   * Destructor
   */
  virtual ~MzmlConvert();


  void writeMzcborIndex(pappso::cbor::CborStreamWriter *writer) const;

  const std::vector<QString> &getRunIdList() const;
  const std::vector<std::vector<qint64>> &getRunAndSpectrumOffsetList() const;
  const std::vector<std::vector<QString>> &getRunAndSpectrumIdList() const;


  protected:
  virtual void readStream() override;

  private:
  void attributeListToCbor(const QXmlStreamAttributes &xml_attributes);
  void attributeValueToCbor(const QStringView &value_str);
  void insideElement(QString &last_element, bool &array_started);

  void getCurrentSpectrumSize();
  void readBinaryDataArrayList();
  QString readBinaryDataArray(QVector<double> &double_array);

  private:
  pappso::UiMonitorInterface *mp_monitor;
  pappso::cbor::CborStreamWriter *mp_cborWriter;

  std::vector<QString> m_elementStash;
  QStringList m_elementToStoreInArray;

  std::size_t m_currentSpectrumSize = 0;

  QVector<double> m_doubleArray;

  std::vector<QString> m_runIdList;
  std::vector<std::vector<qint64>> m_runAndSpectrumOffsetList;
  std::vector<std::vector<QString>> m_runAndSpectrumIdList;
  std::vector<std::vector<qint64>> m_runAndSpectrumTotalIonCountList;
  std::vector<std::vector<std::uint8_t>> m_runAndSpectrumMsLevelList;
  std::vector<std::vector<double>> m_runAndSpectrumRtList;
  QString m_uuid;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
