/*
Copyright (c) 2015 - present Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "CUDA2HIP.h"

// Map of all functions
const std::map<llvm::StringRef, hipCounter> CUDA_SOLVER_FUNCTION_MAP {
  {"cusolverDnCreate",                                   {"hipsolverDnCreate",                                     "rocblas_create_handle",                                          CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnDestroy",                                  {"hipsolverDnDestroy",                                    "rocblas_destroy_handle",                                         CONV_LIB_FUNC, API_SOLVER, 2}},
  // NOTE: cusolverDn(S|D|C|Z)getrf -> rocsolver_(s|d|c|z)getrf + harness of other API calls
  {"cusolverDnSgetrf",                                   {"hipsolverDnSgetrf",                                     "rocsolver_sgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgetrf",                                   {"hipsolverDnDgetrf",                                     "rocsolver_dgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgetrf",                                   {"hipsolverDnCgetrf",                                     "rocsolver_cgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgetrf",                                   {"hipsolverDnZgetrf",                                     "rocsolver_zgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: cusolverDn(S|D|C|Z)getrf_bufferSize -> rocsolver_(s|d|c|z)getrf + harness of other API calls
  {"cusolverDnSgetrf_bufferSize",                        {"hipsolverDnSgetrf_bufferSize",                          "rocsolver_sgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgetrf_bufferSize",                        {"hipsolverDnDgetrf_bufferSize",                          "rocsolver_dgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgetrf_bufferSize",                        {"hipsolverDnCgetrf_bufferSize",                          "rocsolver_cgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgetrf_bufferSize",                        {"hipsolverDnZgetrf_bufferSize",                          "rocsolver_zgetrf",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: cusolverDn(S|D|C|Z)getrs -> rocsolver_(s|d|c|z)getrs + harness of other API calls
  {"cusolverDnSgetrs",                                   {"hipsolverDnSgetrs",                                     "rocsolver_sgetrs",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgetrs",                                   {"hipsolverDnDgetrs",                                     "rocsolver_dgetrs",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgetrs",                                   {"hipsolverDnCgetrs",                                     "rocsolver_cgetrs",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgetrs",                                   {"hipsolverDnZgetrs",                                     "rocsolver_zgetrs",                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgetrf",                                   {"hipsolverDnXgetrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgetrf_bufferSize",                        {"hipsolverDnXgetrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgetrs",                                   {"hipsolverDnXgetrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCreateParams",                             {"hipsolverDnCreateParams",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDestroyParams",                            {"hipsolverDnDestroyParams",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSetAdvOptions",                            {"hipsolverDnSetAdvOptions",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSetStream",                                {"hipsolverSetStream",                                    "rocblas_set_stream",                                             CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnGetStream",                                {"hipsolverGetStream",                                    "rocblas_get_stream",                                             CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnSetDeterministicMode",                     {"hipsolverDnSetDeterministicMode",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnGetDeterministicMode",                     {"hipsolverDnGetDeterministicMode",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnIRSParamsCreate",                          {"hipsolverDnIRSParamsCreate",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsDestroy",                         {"hipsolverDnIRSParamsDestroy",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetRefinementSolver",             {"hipsolverDnIRSParamsSetRefinementSolver",               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetSolverMainPrecision",          {"hipsolverDnIRSParamsSetSolverMainPrecision",            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetSolverLowestPrecision",        {"hipsolverDnIRSParamsSetSolverLowestPrecision",          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetSolverPrecisions",             {"hipsolverDnIRSParamsSetSolverPrecisions",               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetTol",                          {"hipsolverDnIRSParamsSetTol",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetTolInner",                     {"hipsolverDnIRSParamsSetTolInner",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetMaxIters",                     {"hipsolverDnIRSParamsSetMaxIters",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsSetMaxItersInner",                {"hipsolverDnIRSParamsSetMaxItersInner",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsGetMaxIters",                     {"hipsolverDnIRSParamsGetMaxIters",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsEnableFallback",                  {"hipsolverDnIRSParamsEnableFallback",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSParamsDisableFallback",                 {"hipsolverDnIRSParamsDisableFallback",                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosCreate",                           {"hipsolverDnIRSInfosCreate",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosDestroy",                          {"hipsolverDnIRSInfosDestroy",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosGetNiters",                        {"hipsolverDnIRSInfosGetNiters",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosGetOuterNiters",                   {"hipsolverDnIRSInfosGetOuterNiters",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosRequestResidual",                  {"hipsolverDnIRSInfosRequestResidual",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosGetResidualHistory",               {"hipsolverDnIRSInfosGetResidualHistory",                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSInfosGetMaxIters",                      {"hipsolverDnIRSInfosGetMaxIters",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_zgesv has a harness of rocblas_set_workspace, hipsolverZZgesv_bufferSize, and rocsolver_zgesv_outofplace
  {"cusolverDnZZgesv",                                   {"hipsolverDnZZgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZCgesv",                                   {"hipsolverDnZCgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZKgesv",                                   {"hipsolverDnZKgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZEgesv",                                   {"hipsolverDnZEgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZYgesv",                                   {"hipsolverDnZYgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_cgesv has a harness of rocblas_set_workspace, hipsolverCCgesv_bufferSize, and rocsolver_cgesv_outofplace
  {"cusolverDnCCgesv",                                   {"hipsolverDnCCgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCEgesv",                                   {"hipsolverDnCEgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCKgesv",                                   {"hipsolverDnCKgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCYgesv",                                   {"hipsolverDnCYgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_dgesv has a harness of rocblas_set_workspace, hipsolverDDgesv_bufferSize, and rocsolver_dgesv_outofplace
  {"cusolverDnDDgesv",                                   {"hipsolverDnDDgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDSgesv",                                   {"hipsolverDnDSgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDHgesv",                                   {"hipsolverDnDHgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDBgesv",                                   {"hipsolverDnDBgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDXgesv",                                   {"hipsolverDnDXgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_sgesv has a harness of rocblas_set_workspace, hipsolverSSgesv_bufferSize, and rocsolver_sgesv_outofplace
  {"cusolverDnSSgesv",                                   {"hipsolverDnSSgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSHgesv",                                   {"hipsolverDnSHgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSBgesv",                                   {"hipsolverDnSBgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSXgesv",                                   {"hipsolverDnSXgesv",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_zgesv has a harness of rocblas_start_device_memory_size_query, rocsolver_zgesv_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnZZgesv_bufferSize",                        {"hipsolverDnZZgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZCgesv_bufferSize",                        {"hipsolverDnZCgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZKgesv_bufferSize",                        {"hipsolverDnZKgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZEgesv_bufferSize",                        {"hipsolverDnZEgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZYgesv_bufferSize",                        {"hipsolverDnZYgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_cgesv has a harness of rocblas_start_device_memory_size_query, rocsolver_cgesv_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnCCgesv_bufferSize",                        {"hipsolverDnCCgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCKgesv_bufferSize",                        {"hipsolverDnCKgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCEgesv_bufferSize",                        {"hipsolverDnCEgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCYgesv_bufferSize",                        {"hipsolverDnCYgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_dgesv has a harness of rocblas_start_device_memory_size_query, rocsolver_dgesv_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnDDgesv_bufferSize",                        {"hipsolverDnDDgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDSgesv_bufferSize",                        {"hipsolverDnDSgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDHgesv_bufferSize",                        {"hipsolverDnDHgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDBgesv_bufferSize",                        {"hipsolverDnDBgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDXgesv_bufferSize",                        {"hipsolverDnDXgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_sgesv has a harness of rocblas_start_device_memory_size_query, rocsolver_sgesv_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnSSgesv_bufferSize",                        {"hipsolverDnSSgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSHgesv_bufferSize",                        {"hipsolverDnSHgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSBgesv_bufferSize",                        {"hipsolverDnSBgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSXgesv_bufferSize",                        {"hipsolverDnSXgesv_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_zgels has a harness of rocblas_set_workspace, hipsolverZZgels_bufferSize, hipsolverManageWorkspace, and rocsolver_zgels_outofplace
  {"cusolverDnZZgels",                                   {"hipsolverDnZZgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZCgels",                                   {"hipsolverDnZCgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZKgels",                                   {"hipsolverDnZKgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZEgels",                                   {"hipsolverDnZEgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZYgels",                                   {"hipsolverDnZYgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_cgels has a harness of rocblas_set_workspace, hipsolverCCgels_bufferSize, hipsolverManageWorkspace, and rocsolver_cgels_outofplace
  {"cusolverDnCCgels",                                   {"hipsolverDnCCgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCKgels",                                   {"hipsolverDnCKgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCEgels",                                   {"hipsolverDnCEgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCYgels",                                   {"hipsolverDnCYgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_dgels has a harness of rocblas_set_workspace, hipsolverDDgels_bufferSize, hipsolverManageWorkspace, and rocsolver_dgels_outofplace
  {"cusolverDnDDgels",                                   {"hipsolverDnDDgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDSgels",                                   {"hipsolverDnDSgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDHgels",                                   {"hipsolverDnDHgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDBgels",                                   {"hipsolverDnDBgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDXgels",                                   {"hipsolverDnDXgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_sgels has a harness of rocblas_set_workspace, hipsolverSSgels_bufferSize, hipsolverManageWorkspace, and rocsolver_sgels_outofplace
  {"cusolverDnSSgels",                                   {"hipsolverDnSSgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSHgels",                                   {"hipsolverDnSHgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSBgels",                                   {"hipsolverDnSBgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSXgels",                                   {"hipsolverDnSXgels",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_zgels has a harness of rocblas_start_device_memory_size_query, rocsolver_zgels_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnZZgels_bufferSize",                        {"hipsolverDnZZgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZCgels_bufferSize",                        {"hipsolverDnZCgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZKgels_bufferSize",                        {"hipsolverDnZKgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZEgels_bufferSize",                        {"hipsolverDnZEgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZYgels_bufferSize",                        {"hipsolverDnZYgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_cgels has a harness of rocblas_start_device_memory_size_query, rocsolver_cgels_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnCCgels_bufferSize",                        {"hipsolverDnCCgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCKgels_bufferSize",                        {"hipsolverDnCKgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCEgels_bufferSize",                        {"hipsolverDnCEgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCYgels_bufferSize",                        {"hipsolverDnCYgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_dgels has a harness of rocblas_start_device_memory_size_query, rocsolver_dgels_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnDDgels_bufferSize",                        {"hipsolverDnDDgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDSgels_bufferSize",                        {"hipsolverDnDSgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDHgels_bufferSize",                        {"hipsolverDnDHgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDBgels_bufferSize",                        {"hipsolverDnDBgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDXgels_bufferSize",                        {"hipsolverDnDXgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_sgels has a harness of rocblas_start_device_memory_size_query, rocsolver_sgels_outofplace, and rocblas_stop_device_memory_size_query
  {"cusolverDnSSgels_bufferSize",                        {"hipsolverDnSSgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnSHgels_bufferSize",                        {"hipsolverDnSHgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSBgels_bufferSize",                        {"hipsolverDnSBgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSXgels_bufferSize",                        {"hipsolverDnSXgels_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSXgesv",                                 {"hipsolverDnIRSXgesv",                                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSXgesv_bufferSize",                      {"hipsolverDnIRSXgesv_bufferSize",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSXgels",                                 {"hipsolverDnIRSXgels",                                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnIRSXgels_bufferSize",                      {"hipsolverDnIRSXgels_bufferSize",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)potrf has a harness of rocblas_start_device_memory_size_query and rocblas_stop_device_memory_size_query
  {"cusolverDnSpotrf_bufferSize",                        {"hipsolverDnSpotrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotrf_bufferSize",                        {"hipsolverDnDpotrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotrf_bufferSize",                        {"hipsolverDnCpotrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotrf_bufferSize",                        {"hipsolverDnZpotrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // TODO: rocsolver_(s|d|c|z)potrf needs second call to calculate workspaces
  {"cusolverDnSpotrf",                                   {"hipsolverDnSpotrf",                                     "rocsolver_spotrf",                                               CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnDpotrf",                                   {"hipsolverDnDpotrf",                                     "rocsolver_dpotrf",                                               CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnCpotrf",                                   {"hipsolverDnCpotrf",                                     "rocsolver_cpotrf",                                               CONV_LIB_FUNC, API_SOLVER, 2}},
  {"cusolverDnZpotrf",                                   {"hipsolverDnZpotrf",                                     "rocsolver_zpotrf",                                               CONV_LIB_FUNC, API_SOLVER, 2}},
  // NOTE: rocsolver_(s|d|c|z)potrs has a harness of rocblas_set_workspace, hipsolver(S|D|C|Z)potrs_bufferSize, hipsolverManageWorkspace, and hipsolverZeroInfo
  {"cusolverDnSpotrs",                                   {"hipsolverDnSpotrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotrs",                                   {"hipsolverDnDpotrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotrs",                                   {"hipsolverDnCpotrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotrs",                                   {"hipsolverDnZpotrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)potrf_batched has a harness of rocblas_set_workspace, hipsolver(S|D|C|Z)potrfBatched_bufferSize, and hipsolverManageWorkspace
  {"cusolverDnSpotrfBatched",                            {"hipsolverDnSpotrfBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotrfBatched",                            {"hipsolverDnDpotrfBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotrfBatched",                            {"hipsolverDnCpotrfBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotrfBatched",                            {"hipsolverDnZpotrfBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)potrs_batched has a harness of rocblas_set_workspace, hipsolver(S|D|C|Z)potrsBatched_bufferSize, and hipsolverManageWorkspace
  {"cusolverDnSpotrsBatched",                            {"hipsolverDnSpotrsBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotrsBatched",                            {"hipsolverDnDpotrsBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotrsBatched",                            {"hipsolverDnCpotrsBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotrsBatched",                            {"hipsolverDnZpotrsBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)potri has a harness of rocblas_start_device_memory_size_query and rocblas_stop_device_memory_size_query
  {"cusolverDnSpotri_bufferSize",                        {"hipsolverDnSpotri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotri_bufferSize",                        {"hipsolverDnDpotri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotri_bufferSize",                        {"hipsolverDnCpotri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotri_bufferSize",                        {"hipsolverDnZpotri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)potri has a harness of rocblas_set_workspace, hipsolver(S|D|C|Z)potri_bufferSize and hipsolverManageWorkspace
  {"cusolverDnSpotri",                                   {"hipsolverDnSpotri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDpotri",                                   {"hipsolverDnDpotri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCpotri",                                   {"hipsolverDnCpotri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZpotri",                                   {"hipsolverDnZpotri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXtrtri_bufferSize",                        {"hipsolverDnXtrtri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXtrtri",                                   {"hipsolverDnXtrtri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSlauum_bufferSize",                        {"hipsolverDnSlauum_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDlauum_bufferSize",                        {"hipsolverDnDlauum_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnClauum_bufferSize",                        {"hipsolverDnClauum_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZlauum_bufferSize",                        {"hipsolverDnZlauum_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSlauum",                                   {"hipsolverDnSlauum",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDlauum",                                   {"hipsolverDnDlauum",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnClauum",                                   {"hipsolverDnClauum",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZlauum",                                   {"hipsolverDnZlauum",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSlaswp",                                   {"hipsolverDnSlaswp",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDlaswp",                                   {"hipsolverDnDlaswp",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnClaswp",                                   {"hipsolverDnClaswp",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZlaswp",                                   {"hipsolverDnZlaswp",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)geqrf have a harness of other HIP and ROC API calls
  {"cusolverDnSgeqrf_bufferSize",                        {"hipsolverDnSgeqrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgeqrf_bufferSize",                        {"hipsolverDnDgeqrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgeqrf_bufferSize",                        {"hipsolverDnCgeqrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgeqrf_bufferSize",                        {"hipsolverDnZgeqrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)geqrf have a harness of other HIP and ROC API calls
  {"cusolverDnSgeqrf",                                   {"hipsolverDnSgeqrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgeqrf",                                   {"hipsolverDnDgeqrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgeqrf",                                   {"hipsolverDnCgeqrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgeqrf",                                   {"hipsolverDnZgeqrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgqr and rocsolver_(c|z)ungqr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgqr_bufferSize",                        {"hipsolverDnSorgqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgqr_bufferSize",                        {"hipsolverDnDorgqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungqr_bufferSize",                        {"hipsolverDnCungqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungqr_bufferSize",                        {"hipsolverDnZungqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgqr and rocsolver_(c|z)ungqr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgqr",                                   {"hipsolverDnSorgqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgqr",                                   {"hipsolverDnDorgqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungqr",                                   {"hipsolverDnCungqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungqr",                                   {"hipsolverDnZungqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)ormqr and rocsolver_(c|z)unmqr have a harness of other HIP and ROC API calls
  {"cusolverDnSormqr_bufferSize",                        {"hipsolverDnSormqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDormqr_bufferSize",                        {"hipsolverDnDormqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCunmqr_bufferSize",                        {"hipsolverDnCunmqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZunmqr_bufferSize",                        {"hipsolverDnZunmqr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)ormqr and rocsolver_(c|z)unmqr have a harness of other HIP and ROC API calls
  {"cusolverDnSormqr",                                   {"hipsolverDnSormqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDormqr",                                   {"hipsolverDnDormqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCunmqr",                                   {"hipsolverDnCunmqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZunmqr",                                   {"hipsolverDnZunmqr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)sytrf have a harness of other HIP and ROC API calls
  {"cusolverDnSsytrf_bufferSize",                        {"hipsolverDnSsytrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsytrf_bufferSize",                        {"hipsolverDnDsytrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCsytrf_bufferSize",                        {"hipsolverDnCsytrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZsytrf_bufferSize",                        {"hipsolverDnZsytrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)sytrf have a harness of other HIP and ROC API calls
  {"cusolverDnSsytrf",                                   {"hipsolverDnSsytrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsytrf",                                   {"hipsolverDnDsytrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCsytrf",                                   {"hipsolverDnCsytrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZsytrf",                                   {"hipsolverDnZsytrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsytrs_bufferSize",                        {"hipsolverDnXsytrs_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsytrs",                                   {"hipsolverDnXsytrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSsytri_bufferSize",                        {"hipsolverDnSsytri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDsytri_bufferSize",                        {"hipsolverDnDsytri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCsytri_bufferSize",                        {"hipsolverDnCsytri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZsytri_bufferSize",                        {"hipsolverDnZsytri_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSsytri",                                   {"hipsolverDnSsytri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnDsytri",                                   {"hipsolverDnDsytri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnCsytri",                                   {"hipsolverDnCsytri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnZsytri",                                   {"hipsolverDnZsytri",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gebrd have a harness of other HIP and ROC API calls
  {"cusolverDnSgebrd_bufferSize",                        {"hipsolverDnSgebrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgebrd_bufferSize",                        {"hipsolverDnDgebrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgebrd_bufferSize",                        {"hipsolverDnCgebrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgebrd_bufferSize",                        {"hipsolverDnZgebrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gebrd have a harness of other HIP and ROC API calls
  {"cusolverDnSgebrd",                                   {"hipsolverDnSgebrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgebrd",                                   {"hipsolverDnDgebrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgebrd",                                   {"hipsolverDnCgebrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgebrd",                                   {"hipsolverDnZgebrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgbr and rocsolver_(c|z)ungbr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgbr_bufferSize",                        {"hipsolverDnSorgbr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgbr_bufferSize",                        {"hipsolverDnDorgbr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungbr_bufferSize",                        {"hipsolverDnCungbr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungbr_bufferSize",                        {"hipsolverDnZungbr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgbr and rocsolver_(c|z)ungbr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgbr",                                   {"hipsolverDnSorgbr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgbr",                                   {"hipsolverDnDorgbr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungbr",                                   {"hipsolverDnCungbr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungbr",                                   {"hipsolverDnZungbr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sytrd and rocsolver_(c|z)hetrd have a harness of other HIP and ROC API calls
  {"cusolverDnSsytrd_bufferSize",                        {"hipsolverDnSsytrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsytrd_bufferSize",                        {"hipsolverDnDsytrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChetrd_bufferSize",                        {"hipsolverDnChetrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhetrd_bufferSize",                        {"hipsolverDnZhetrd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sytrd and rocsolver_(c|z)hetrd have a harness of other HIP and ROC API calls
  {"cusolverDnSsytrd",                                   {"hipsolverDnSsytrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsytrd",                                   {"hipsolverDnDsytrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChetrd",                                   {"hipsolverDnChetrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhetrd",                                   {"hipsolverDnZhetrd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgtr and rocsolver_(c|z)ungtr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgtr_bufferSize",                        {"hipsolverDnSorgtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgtr_bufferSize",                        {"hipsolverDnDorgtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungtr_bufferSize",                        {"hipsolverDnCungtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungtr_bufferSize",                        {"hipsolverDnZungtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)orgtr and rocsolver_(c|z)ungtr have a harness of other HIP and ROC API calls
  {"cusolverDnSorgtr",                                   {"hipsolverDnSorgtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDorgtr",                                   {"hipsolverDnDorgtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCungtr",                                   {"hipsolverDnCungtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZungtr",                                   {"hipsolverDnZungtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)ormtr and rocsolver_(c|z)unmtr have a harness of other HIP and ROC API calls
  {"cusolverDnSormtr_bufferSize",                        {"hipsolverDnSormtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDormtr_bufferSize",                        {"hipsolverDnDormtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCunmtr_bufferSize",                        {"hipsolverDnCunmtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZunmtr_bufferSize",                        {"hipsolverDnZunmtr_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)ormtr and rocsolver_(c|z)unmtr have a harness of other HIP and ROC API calls
  {"cusolverDnSormtr",                                   {"hipsolverDnSormtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDormtr",                                   {"hipsolverDnDormtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCunmtr",                                   {"hipsolverDnCunmtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZunmtr",                                   {"hipsolverDnZunmtr",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvd have a harness of other HIP and ROC API calls
  {"cusolverDnSgesvd_bufferSize",                        {"hipsolverDnSgesvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvd_bufferSize",                        {"hipsolverDnDgesvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvd_bufferSize",                        {"hipsolverDnCgesvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvd_bufferSize",                        {"hipsolverDnZgesvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvd have a harness of other HIP and ROC API calls
  {"cusolverDnSgesvd",                                   {"hipsolverDnSgesvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvd",                                   {"hipsolverDnDgesvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvd",                                   {"hipsolverDnCgesvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvd",                                   {"hipsolverDnZgesvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevd and rocsolver_(c|z)heevd have a harness of other HIP and ROC API calls
  {"cusolverDnSsyevd_bufferSize",                        {"hipsolverDnSsyevd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevd_bufferSize",                        {"hipsolverDnDsyevd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevd_bufferSize",                        {"hipsolverDnCheevd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevd_bufferSize",                        {"hipsolverDnZheevd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevd and rocsolver_(c|z)heevd have a harness of other HIP and ROC API calls
  {"cusolverDnSsyevd",                                   {"hipsolverDnSsyevd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevd",                                   {"hipsolverDnDsyevd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevd",                                   {"hipsolverDnCheevd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevd",                                   {"hipsolverDnZheevd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevdx_inplace and rocsolver_(c|z)heevdx_inplace have a harness of other ROC API calls
  {"cusolverDnSsyevdx_bufferSize",                       {"hipsolverDnSsyevdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevdx_bufferSize",                       {"hipsolverDnDsyevdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevdx_bufferSize",                       {"hipsolverDnCheevdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevdx_bufferSize",                       {"hipsolverDnZheevdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevdx_inplace and rocsolver_(c|z)heevdx_inplace have a harness of other ROC and HIP API calls
  {"cusolverDnSsyevdx",                                  {"hipsolverDnSsyevdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevdx",                                  {"hipsolverDnDsyevdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevdx",                                  {"hipsolverDnCheevdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevdx",                                  {"hipsolverDnZheevdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvdx_inplace and rocsolver_(c|z)hegvdx_inplace have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvdx_bufferSize",                       {"hipsolverDnSsygvdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvdx_bufferSize",                       {"hipsolverDnDsygvdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvdx_bufferSize",                       {"hipsolverDnChegvdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvdx_bufferSize",                       {"hipsolverDnZhegvdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvdx_inplace and rocsolver_(c|z)hegvdx_inplace have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvdx",                                  {"hipsolverDnSsygvdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvdx",                                  {"hipsolverDnDsygvdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvdx",                                  {"hipsolverDnChegvdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvdx",                                  {"hipsolverDnZhegvdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvd and rocsolver_(c|z)hegvd have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvd_bufferSize",                        {"hipsolverDnSsygvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvd_bufferSize",                        {"hipsolverDnDsygvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvd_bufferSize",                        {"hipsolverDnChegvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvd_bufferSize",                        {"hipsolverDnZhegvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvd and rocsolver_(c|z)hegvd have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvd",                                   {"hipsolverDnSsygvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvd",                                   {"hipsolverDnDsygvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvd",                                   {"hipsolverDnChegvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvd",                                   {"hipsolverDnZhegvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverDnCreateSyevjInfo",                          {"hipsolverDnCreateSyevjInfo",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDestroySyevjInfo",                         {"hipsolverDnDestroySyevjInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevjSetTolerance",                       {"hipsolverDnXsyevjSetTolerance",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevjSetMaxSweeps",                       {"hipsolverDnXsyevjSetMaxSweeps",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevjSetSortEig",                         {"hipsolverDnXsyevjSetSortEig",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevjGetResidual",                        {"hipsolverDnXsyevjGetResidual",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevjGetSweeps",                          {"hipsolverDnXsyevjGetSweeps",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevj_strided_batched and rocsolver_(c|z)heevj_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSsyevjBatched_bufferSize",                 {"hipsolverDnSsyevjBatched_bufferSize",                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevjBatched_bufferSize",                 {"hipsolverDnDsyevjBatched_bufferSize",                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevjBatched_bufferSize",                 {"hipsolverDnCheevjBatched_bufferSize",                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevjBatched_bufferSize",                 {"hipsolverDnZheevjBatched_bufferSize",                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevj_strided_batched and rocsolver_(c|z)heevj_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSsyevjBatched",                            {"hipsolverDnSsyevjBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevjBatched",                            {"hipsolverDnDsyevjBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevjBatched",                            {"hipsolverDnCheevjBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevjBatched",                            {"hipsolverDnZheevjBatched",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevj and rocsolver_(c|z)heevj have a harness of other ROC and HIP API calls
  {"cusolverDnSsyevj_bufferSize",                        {"hipsolverDnSsyevj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevj_bufferSize",                        {"hipsolverDnDsyevj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevj_bufferSize",                        {"hipsolverDnCheevj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevj_bufferSize",                        {"hipsolverDnZheevj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)syevj and rocsolver_(c|z)heevj have a harness of other ROC and HIP API calls
  {"cusolverDnSsyevj",                                   {"hipsolverDnSsyevj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsyevj",                                   {"hipsolverDnDsyevj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCheevj",                                   {"hipsolverDnCheevj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZheevj",                                   {"hipsolverDnZheevj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvj and rocsolver_(c|z)hegvj have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvj_bufferSize",                        {"hipsolverDnSsygvj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvj_bufferSize",                        {"hipsolverDnDsygvj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvj_bufferSize",                        {"hipsolverDnChegvj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvj_bufferSize",                        {"hipsolverDnZhegvj_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d)sygvj and rocsolver_(c|z)hegvj have a harness of other ROC and HIP API calls
  {"cusolverDnSsygvj",                                   {"hipsolverDnSsygvj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDsygvj",                                   {"hipsolverDnDsygvj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnChegvj",                                   {"hipsolverDnChegvj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZhegvj",                                   {"hipsolverDnZhegvj",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverDnCreateGesvdjInfo",                         {"hipsolverDnCreateGesvdjInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDestroyGesvdjInfo",                        {"hipsolverDnDestroyGesvdjInfo",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgesvdjSetTolerance",                      {"hipsolverDnXgesvdjSetTolerance",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgesvdjSetMaxSweeps",                      {"hipsolverDnXgesvdjSetMaxSweeps",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgesvdjSetSortEig",                        {"hipsolverDnXgesvdjSetSortEig",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgesvdjGetResidual",                       {"hipsolverDnXgesvdjGetResidual",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgesvdjGetSweeps",                         {"hipsolverDnXgesvdjGetSweeps",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdj_notransv_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdjBatched_bufferSize",                {"hipsolverDnSgesvdjBatched_bufferSize",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdjBatched_bufferSize",                {"hipsolverDnDgesvdjBatched_bufferSize",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdjBatched_bufferSize",                {"hipsolverDnCgesvdjBatched_bufferSize",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdjBatched_bufferSize",                {"hipsolverDnZgesvdjBatched_bufferSize",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdj_notransv_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdjBatched",                           {"hipsolverDnSgesvdjBatched",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdjBatched",                           {"hipsolverDnDgesvdjBatched",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdjBatched",                           {"hipsolverDnCgesvdjBatched",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdjBatched",                           {"hipsolverDnZgesvdjBatched",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdj_notransv have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdj_bufferSize",                       {"hipsolverDnSgesvdj_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdj_bufferSize",                       {"hipsolverDnDgesvdj_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdj_bufferSize",                       {"hipsolverDnCgesvdj_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdj_bufferSize",                       {"hipsolverDnZgesvdj_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdj_notransv have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdj",                                  {"hipsolverDnSgesvdj",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdj",                                  {"hipsolverDnDgesvdj",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdj",                                  {"hipsolverDnCgesvdj",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdj",                                  {"hipsolverDnZgesvdj",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdx_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdaStridedBatched_bufferSize",         {"hipsolverDnSgesvdaStridedBatched_bufferSize",           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdaStridedBatched_bufferSize",         {"hipsolverDnDgesvdaStridedBatched_bufferSize",           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdaStridedBatched_bufferSize",         {"hipsolverDnCgesvdaStridedBatched_bufferSize",           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdaStridedBatched_bufferSize",         {"hipsolverDnZgesvdaStridedBatched_bufferSize",           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_(s|d|c|z)gesvdx_strided_batched have a harness of other ROC and HIP API calls
  {"cusolverDnSgesvdaStridedBatched",                    {"hipsolverDnSgesvdaStridedBatched",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnDgesvdaStridedBatched",                    {"hipsolverDnDgesvdaStridedBatched",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnCgesvdaStridedBatched",                    {"hipsolverDnCgesvdaStridedBatched",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnZgesvdaStridedBatched",                    {"hipsolverDnZgesvdaStridedBatched",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnPotrf_bufferSize",                         {"hipsolverDnPotrf_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnPotrf",                                    {"hipsolverDnPotrf",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnPotrs",                                    {"hipsolverDnPotrs",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGeqrf_bufferSize",                         {"hipsolverDnGeqrf_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGeqrf",                                    {"hipsolverDnGeqrf",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGetrf_bufferSize",                         {"hipsolverDnGetrf_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGetrf",                                    {"hipsolverDnGetrf",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGetrs",                                    {"hipsolverDnGetrs",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSyevd_bufferSize",                         {"hipsolverDnSyevd_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSyevd",                                    {"hipsolverDnSyevd",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSyevdx_bufferSize",                        {"hipsolverDnSyevdx_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnSyevdx",                                   {"hipsolverDnSyevdx",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGesvd_bufferSize",                         {"hipsolverDnGesvd_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnGesvd",                                    {"hipsolverDnGesvd",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXpotrf_bufferSize",                        {"hipsolverDnXpotrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXpotrf",                                   {"hipsolverDnXpotrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXpotrs",                                   {"hipsolverDnXpotrs",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgeqrf_bufferSize",                        {"hipsolverDnXgeqrf_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXgeqrf",                                   {"hipsolverDnXgeqrf",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverDnXsyevBatched",                             {"hipsolverDnXsyevBatched",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsyevBatched_bufferSize",                  {"hipsolverDnXsyevBatched_bufferSize",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsyevd_bufferSize",                        {"hipsolverDnXsyevd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsyevd",                                   {"hipsolverDnXsyevd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsyevdx_bufferSize",                       {"hipsolverDnXsyevdx_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXsyevdx",                                  {"hipsolverDnXsyevdx",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvd_bufferSize",                        {"hipsolverDnXgesvd_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgeev",                                    {"hipsolverDnXgeev",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgeev_bufferSize",                         {"hipsolverDnXgeev_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvd",                                   {"hipsolverDnXgesvd",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvdp_bufferSize",                       {"hipsolverDnXgesvdp_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvdp",                                  {"hipsolverDnXgesvdp",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvdr_bufferSize",                       {"hipsolverDnXgesvdr_bufferSize",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXgesvdr",                                  {"hipsolverDnXgesvdr",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXlarft_bufferSize",                        {"hipsolverDnXlarft_bufferSize",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnXlarft",                                   {"hipsolverDnXlarft",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerSetCallback",                        {"hipsolverDnLoggerSetCallback",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerSetFile",                            {"hipsolverDnLoggerSetFile",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerOpenFile",                           {"hipsolverDnLoggerOpenFile",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerSetLevel",                           {"hipsolverDnLoggerSetLevel",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerSetMask",                            {"hipsolverDnLoggerSetMask",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverDnLoggerForceDisable",                       {"hipsolverDnLoggerForceDisable",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgCreate",                                   {"hipsolverMgCreate",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgDestroy",                                  {"hipsolverMgDestroy",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgDeviceSelect",                             {"hipsolverMgDeviceSelect",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgCreateDeviceGrid",                         {"hipsolverMgCreateDeviceGrid",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgDestroyGrid",                              {"hipsolverMgDestroyGrid",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgCreateMatrixDesc",                         {"hipsolverMgCreateMatrixDesc",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgSyevd_bufferSize",                         {"hipsolverMgSyevd_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgSyevd",                                    {"hipsolverMgSyevd",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgGetrf_bufferSize",                         {"hipsolverMgGetrf_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgGetrf",                                    {"hipsolverMgGetrf",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgGetrs_bufferSize",                         {"hipsolverMgGetrs_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgGetrs",                                    {"hipsolverMgGetrs",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotrf_bufferSize",                         {"hipsolverMgPotrf_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotrf",                                    {"hipsolverMgPotrf",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotrs_bufferSize",                         {"hipsolverMgPotrs_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotrs",                                    {"hipsolverMgPotrs",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotri_bufferSize",                         {"hipsolverMgPotri_bufferSize",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverMgPotri",                                    {"hipsolverMgPotri",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  // NOTE: rocsolver_create_rfinfo have a harness of other ROC and HIP API calls
  {"cusolverRfCreate",                                   {"hipsolverRfCreate",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_destroy_rfinfo have a harness of other ROC and HIP API calls
  {"cusolverRfDestroy",                                  {"hipsolverRfDestroy",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfGetMatrixFormat",                          {"hipsolverRfGetMatrixFormat",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfSetMatrixFormat",                          {"hipsolverRfSetMatrixFormat",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfSetNumericProperties",                     {"hipsolverRfSetNumericProperties",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfGetNumericProperties",                     {"hipsolverRfGetNumericProperties",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfGetNumericBoostReport",                    {"hipsolverRfGetNumericBoostReport",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfSetAlgs",                                  {"hipsolverRfSetAlgs",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfGetAlgs",                                  {"hipsolverRfGetAlgs",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverRfGetResetValuesFastMode",                   {"hipsolverRfGetResetValuesFastMode",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverRfSetResetValuesFastMode",                   {"hipsolverRfSetResetValuesFastMode",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // NOTE: rocsolver_dcsrrf_sumlu have a harness of other ROC and HIP API calls
  {"cusolverRfSetupHost",                                {"hipsolverRfSetupHost",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // NOTE: rocsolver_dcsrrf_sumlu have a harness of other ROC and HIP API calls
  {"cusolverRfSetupDevice",                              {"hipsolverRfSetupDevice",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // no ROC analogues
  {"cusolverRfResetValues",                              {"hipsolverRfResetValues",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // NOTE: can't call rocsolver_dcsrrf_analysis w/o using hipSOLVER's hipsolverRfHandle
  {"cusolverRfAnalyze",                                  {"hipsolverRfAnalyze",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // NOTE: can't call rocsolver_dcsrrf_refactlu w/o using hipSOLVER's hipsolverRfHandle
  {"cusolverRfRefactor",                                 {"hipsolverRfRefactor",                                   "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // no ROC analogues
  {"cusolverRfAccessBundledFactorsDevice",               {"hipsolverRfAccessBundledFactorsDevice",                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // no ROC analogues
  {"cusolverRfExtractBundledFactorsHost",                {"hipsolverRfExtractBundledFactorsHost",                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // no ROC analogues
  {"cusolverRfExtractSplitFactorsHost",                  {"hipsolverRfExtractSplitFactorsHost",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // NOTE: can't call rocsolver_dcsrrf_solve w/o using hipSOLVER's hipsolverRfHandle
  {"cusolverRfSolve",                                    {"hipsolverRfSolve",                                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // no ROC analogues
  {"cusolverRfBatchSetupHost",                           {"hipsolverRfBatchSetupHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfBatchResetValues",                         {"hipsolverRfBatchResetValues",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfBatchAnalyze",                             {"hipsolverRfBatchAnalyze",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfBatchRefactor",                            {"hipsolverRfBatchRefactor",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfBatchSolve",                               {"hipsolverRfBatchSolve",                                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  // no ROC analogues
  {"cusolverRfBatchZeroPivot",                           {"hipsolverRfBatchZeroPivot",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},

  {"cusolverSpCreate",                                   {"hipsolverSpCreate",                                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpDestroy",                                  {"hipsolverSpDestroy",                                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpSetStream",                                {"hipsolverSpSetStream",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpGetStream",                                {"hipsolverSpGetStream",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrissymHost",                            {"hipsolverSpXcsrissymHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrlsvluHost",                            {"hipsolverSpScsrlsvluHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrlsvluHost",                            {"hipsolverSpDcsrlsvluHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrlsvluHost",                            {"hipsolverSpCcsrlsvluHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrlsvluHost",                            {"hipsolverSpZcsrlsvluHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrlsvqr",                                {"hipsolverSpScsrlsvqr",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpDcsrlsvqr",                                {"hipsolverSpDcsrlsvqr",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpCcsrlsvqr",                                {"hipsolverSpCcsrlsvqr",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpZcsrlsvqr",                                {"hipsolverSpZcsrlsvqr",                                  "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED}},
  {"cusolverSpScsrlsvqrHost",                            {"hipsolverSpScsrlsvqrHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrlsvqrHost",                            {"hipsolverSpDcsrlsvqrHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrlsvqrHost",                            {"hipsolverSpCcsrlsvqrHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrlsvqrHost",                            {"hipsolverSpZcsrlsvqrHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrlsvcholHost",                          {"hipsolverSpScsrlsvcholHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrlsvcholHost",                          {"hipsolverSpDcsrlsvcholHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrlsvcholHost",                          {"hipsolverSpCcsrlsvcholHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrlsvcholHost",                          {"hipsolverSpZcsrlsvcholHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrlsvchol",                              {"hipsolverSpScsrlsvchol",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrlsvchol",                              {"hipsolverSpDcsrlsvchol",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrlsvchol",                              {"hipsolverSpCcsrlsvchol",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrlsvchol",                              {"hipsolverSpZcsrlsvchol",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrlsqvqrHost",                           {"hipsolverSpScsrlsqvqrHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrlsqvqrHost",                           {"hipsolverSpDcsrlsqvqrHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrlsqvqrHost",                           {"hipsolverSpCcsrlsqvqrHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrlsqvqrHost",                           {"hipsolverSpZcsrlsqvqrHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsreigvsiHost",                           {"hipsolverSpScsreigvsiHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsreigvsiHost",                           {"hipsolverSpDcsreigvsiHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsreigvsiHost",                           {"hipsolverSpCcsreigvsiHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsreigvsiHost",                           {"hipsolverSpZcsreigvsiHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsreigvsi",                               {"hipsolverSpScsreigvsi",                                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsreigvsi",                               {"hipsolverSpDcsreigvsi",                                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsreigvsi",                               {"hipsolverSpCcsreigvsi",                                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsreigvsi",                               {"hipsolverSpZcsreigvsi",                                 "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsreigsHost",                             {"hipsolverSpScsreigsHost",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsreigsHost",                             {"hipsolverSpDcsreigsHost",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsreigsHost",                             {"hipsolverSpCcsreigsHost",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsreigsHost",                             {"hipsolverSpZcsreigsHost",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrsymrcmHost",                           {"hipsolverSpXcsrsymrcmHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrsymmdqHost",                           {"hipsolverSpXcsrsymmdqHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrsymamdHost",                           {"hipsolverSpXcsrsymamdHost",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrmetisndHost",                          {"hipsolverSpXcsrmetisndHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrzfdHost",                              {"hipsolverSpScsrzfdHost",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrzfdHost",                              {"hipsolverSpDcsrzfdHost",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrzfdHost",                              {"hipsolverSpCcsrzfdHost",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrzfdHost",                              {"hipsolverSpZcsrzfdHost",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrperm_bufferSizeHost",                  {"hipsolverSpXcsrperm_bufferSizeHost",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrpermHost",                             {"hipsolverSpXcsrpermHost",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCreateCsrqrInfo",                          {"hipsolverSpCreateCsrqrInfo",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDestroyCsrqrInfo",                         {"hipsolverSpDestroyCsrqrInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrqrAnalysisBatched",                    {"hipsolverSpXcsrqrAnalysisBatched",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrBufferInfoBatched",                  {"hipsolverSpScsrqrBufferInfoBatched",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrBufferInfoBatched",                  {"hipsolverSpDcsrqrBufferInfoBatched",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrBufferInfoBatched",                  {"hipsolverSpCcsrqrBufferInfoBatched",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrBufferInfoBatched",                  {"hipsolverSpZcsrqrBufferInfoBatched",                    "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrsvBatched",                          {"hipsolverSpScsrqrsvBatched",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrsvBatched",                          {"hipsolverSpDcsrqrsvBatched",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrsvBatched",                          {"hipsolverSpCcsrqrsvBatched",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrsvBatched",                          {"hipsolverSpZcsrqrsvBatched",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCreateCsrluInfoHost",                      {"hipsolverSpCreateCsrluInfoHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDestroyCsrluInfoHost",                     {"hipsolverSpDestroyCsrluInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrluAnalysisHost",                       {"hipsolverSpXcsrluAnalysisHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrluBufferInfoHost",                     {"hipsolverSpScsrluBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrluBufferInfoHost",                     {"hipsolverSpDcsrluBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrluBufferInfoHost",                     {"hipsolverSpCcsrluBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrluBufferInfoHost",                     {"hipsolverSpZcsrluBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrluFactorHost",                         {"hipsolverSpScsrluFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrluFactorHost",                         {"hipsolverSpDcsrluFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrluFactorHost",                         {"hipsolverSpCcsrluFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrluFactorHost",                         {"hipsolverSpZcsrluFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrluZeroPivotHost",                      {"hipsolverSpScsrluZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrluZeroPivotHost",                      {"hipsolverSpDcsrluZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrluZeroPivotHost",                      {"hipsolverSpCcsrluZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrluZeroPivotHost",                      {"hipsolverSpZcsrluZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrluSolveHost",                          {"hipsolverSpScsrluSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrluSolveHost",                          {"hipsolverSpDcsrluSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrluSolveHost",                          {"hipsolverSpCcsrluSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrluSolveHost",                          {"hipsolverSpZcsrluSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpXcsrluNnzHost",                            {"hipsolverSpXcsrluNnzHost",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrluExtractHost",                        {"hipsolverSpScsrluExtractHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrluExtractHost",                        {"hipsolverSpDcsrluExtractHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrluExtractHost",                        {"hipsolverSpCcsrluExtractHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrluExtractHost",                        {"hipsolverSpZcsrluExtractHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCreateCsrqrInfoHost",                      {"hipsolverSpCreateCsrqrInfoHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDestroyCsrqrInfoHost",                     {"hipsolverSpDestroyCsrqrInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrqrAnalysisHost",                       {"hipsolverSpXcsrqrAnalysisHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrBufferInfoHost",                     {"hipsolverSpScsrqrBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrBufferInfoHost",                     {"hipsolverSpDcsrqrBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrBufferInfoHost",                     {"hipsolverSpCcsrqrBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrBufferInfoHost",                     {"hipsolverSpZcsrqrBufferInfoHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrSetupHost",                          {"hipsolverSpScsrqrSetupHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrSetupHost",                          {"hipsolverSpDcsrqrSetupHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrSetupHost",                          {"hipsolverSpCcsrqrSetupHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrSetupHost",                          {"hipsolverSpZcsrqrSetupHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrFactorHost",                         {"hipsolverSpScsrqrFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrFactorHost",                         {"hipsolverSpDcsrqrFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrFactorHost",                         {"hipsolverSpCcsrqrFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrFactorHost",                         {"hipsolverSpZcsrqrFactorHost",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrZeroPivotHost",                      {"hipsolverSpScsrqrZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrZeroPivotHost",                      {"hipsolverSpDcsrqrZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrZeroPivotHost",                      {"hipsolverSpCcsrqrZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrZeroPivotHost",                      {"hipsolverSpZcsrqrZeroPivotHost",                        "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrSolveHost",                          {"hipsolverSpScsrqrSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrSolveHost",                          {"hipsolverSpDcsrqrSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrSolveHost",                          {"hipsolverSpCcsrqrSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrSolveHost",                          {"hipsolverSpZcsrqrSolveHost",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrqrAnalysis",                           {"hipsolverSpXcsrqrAnalysis",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrBufferInfo",                         {"hipsolverSpScsrqrBufferInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrBufferInfo",                         {"hipsolverSpDcsrqrBufferInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrBufferInfo",                         {"hipsolverSpCcsrqrBufferInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrBufferInfo",                         {"hipsolverSpZcsrqrBufferInfo",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrSetup",                              {"hipsolverSpScsrqrSetup",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrSetup",                              {"hipsolverSpDcsrqrSetup",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrSetup",                              {"hipsolverSpCcsrqrSetup",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrSetup",                              {"hipsolverSpZcsrqrSetup",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrFactor",                             {"hipsolverSpScsrqrFactor",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrFactor",                             {"hipsolverSpDcsrqrFactor",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrFactor",                             {"hipsolverSpCcsrqrFactor",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrFactor",                             {"hipsolverSpZcsrqrFactor",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrZeroPivot",                          {"hipsolverSpScsrqrZeroPivot",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrZeroPivot",                          {"hipsolverSpDcsrqrZeroPivot",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrZeroPivot",                          {"hipsolverSpCcsrqrZeroPivot",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrZeroPivot",                          {"hipsolverSpZcsrqrZeroPivot",                            "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpScsrqrSolve",                              {"hipsolverSpScsrqrSolve",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDcsrqrSolve",                              {"hipsolverSpDcsrqrSolve",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCcsrqrSolve",                              {"hipsolverSpCcsrqrSolve",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpZcsrqrSolve",                              {"hipsolverSpZcsrqrSolve",                                "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpCreateCsrcholInfoHost",                    {"hipsolverSpCreateCsrcholInfoHost",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpDestroyCsrcholInfoHost",                   {"hipsolverSpDestroyCsrcholInfoHost",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED}},
  {"cusolverSpXcsrcholAnalysisHost",                     {"hipsolverSpXcsrcholAnalysisHost",                       "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholBufferInfoHost",                   {"hipsolverSpScsrcholBufferInfoHost",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholBufferInfoHost",                   {"hipsolverSpDcsrcholBufferInfoHost",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholBufferInfoHost",                   {"hipsolverSpCcsrcholBufferInfoHost",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholBufferInfoHost",                   {"hipsolverSpZcsrcholBufferInfoHost",                     "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholFactorHost",                       {"hipsolverSpScsrcholFactorHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholFactorHost",                       {"hipsolverSpDcsrcholFactorHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholFactorHost",                       {"hipsolverSpCcsrcholFactorHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholFactorHost",                       {"hipsolverSpZcsrcholFactorHost",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholZeroPivotHost",                    {"hipsolverSpScsrcholZeroPivotHost",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholZeroPivotHost",                    {"hipsolverSpDcsrcholZeroPivotHost",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholZeroPivotHost",                    {"hipsolverSpCcsrcholZeroPivotHost",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholZeroPivotHost",                    {"hipsolverSpZcsrcholZeroPivotHost",                      "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholSolveHost",                        {"hipsolverSpScsrcholSolveHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholSolveHost",                        {"hipsolverSpDcsrcholSolveHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholSolveHost",                        {"hipsolverSpCcsrcholSolveHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholSolveHost",                        {"hipsolverSpZcsrcholSolveHost",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCreateCsrcholInfo",                        {"hipsolverSpCreateCsrcholInfo",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDestroyCsrcholInfo",                       {"hipsolverSpDestroyCsrcholInfo",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpXcsrcholAnalysis",                         {"hipsolverSpXcsrcholAnalysis",                           "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholBufferInfo",                       {"hipsolverSpScsrcholBufferInfo",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholBufferInfo",                       {"hipsolverSpDcsrcholBufferInfo",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholBufferInfo",                       {"hipsolverSpCcsrcholBufferInfo",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholBufferInfo",                       {"hipsolverSpZcsrcholBufferInfo",                         "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholFactor",                           {"hipsolverSpScsrcholFactor",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholFactor",                           {"hipsolverSpDcsrcholFactor",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholFactor",                           {"hipsolverSpCcsrcholFactor",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholFactor",                           {"hipsolverSpZcsrcholFactor",                             "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholZeroPivot",                        {"hipsolverSpScsrcholZeroPivot",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholZeroPivot",                        {"hipsolverSpDcsrcholZeroPivot",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholZeroPivot",                        {"hipsolverSpCcsrcholZeroPivot",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholZeroPivot",                        {"hipsolverSpZcsrcholZeroPivot",                          "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholSolve",                            {"hipsolverSpScsrcholSolve",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholSolve",                            {"hipsolverSpDcsrcholSolve",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholSolve",                            {"hipsolverSpCcsrcholSolve",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholSolve",                            {"hipsolverSpZcsrcholSolve",                              "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpScsrcholDiag",                             {"hipsolverSpScsrcholDiag",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpDcsrcholDiag",                             {"hipsolverSpDcsrcholDiag",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpCcsrcholDiag",                             {"hipsolverSpCcsrcholDiag",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusolverSpZcsrcholDiag",                             {"hipsolverSpZcsrcholDiag",                               "",                                                               CONV_LIB_FUNC, API_SOLVER, 2, UNSUPPORTED | CUDA_DEPRECATED}},
};

const std::map<llvm::StringRef, cudaAPIversions> CUDA_SOLVER_FUNCTION_VER_MAP {
  {"cusolverDnCreateParams",                             {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDestroyParams",                            {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSetAdvOptions",                            {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgetrf",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgetrf_bufferSize",                        {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgetrs",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnSetDeterministicMode",                     {CUDA_122, CUDA_0,   CUDA_0  }},
  {"cusolverDnGetDeterministicMode",                     {CUDA_122, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsCreate",                          {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsDestroy",                         {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetRefinementSolver",             {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetSolverMainPrecision",          {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetSolverLowestPrecision",        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetSolverPrecisions",             {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetTol",                          {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetTolInner",                     {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetMaxIters",                     {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsSetMaxItersInner",                {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsGetMaxIters",                     {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsEnableFallback",                  {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSParamsDisableFallback",                 {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosCreate",                           {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosDestroy",                          {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosGetNiters",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosGetOuterNiters",                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosRequestResidual",                  {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosGetResidualHistory",               {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSInfosGetMaxIters",                      {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZZgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZCgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZKgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZEgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZYgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCCgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnCEgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCKgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnCYgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDDgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDSgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDHgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDBgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDXgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSSgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnSHgesv",                                   {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnSBgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSXgesv",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZZgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZCgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZKgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnZEgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZYgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCCgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnCKgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnCEgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCYgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDDgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDSgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDHgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnDBgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDXgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSSgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnSHgesv_bufferSize",                        {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnSBgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSXgesv_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZZgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZCgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZKgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZEgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZYgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCCgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCKgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCEgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCYgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDDgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDSgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDHgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDBgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDXgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSSgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSHgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSBgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSXgels",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZZgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZCgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZKgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZEgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnZYgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCCgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCKgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCEgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnCYgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDDgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDSgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDHgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDBgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnDXgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSSgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSHgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSBgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSXgels_bufferSize",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSXgesv",                                 {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSXgesv_bufferSize",                      {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSXgels",                                 {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnIRSXgels_bufferSize",                      {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverDnSpotrfBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDpotrfBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCpotrfBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZpotrfBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSpotrsBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDpotrsBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCpotrsBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZpotrsBatched",                            {CUDA_91,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSpotri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDpotri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCpotri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZpotri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSpotri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDpotri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCpotri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZpotri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnXtrtri_bufferSize",                        {CUDA_114, CUDA_0,   CUDA_0  }},
  {"cusolverDnXtrtri",                                   {CUDA_114, CUDA_0,   CUDA_0  }},
  {"cusolverDnSlauum_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDlauum_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnClauum_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZlauum_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSlauum",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDlauum",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnClauum",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZlauum",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgqr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgqr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungqr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungqr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSormqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDormqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCunmqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZunmqr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsytrs_bufferSize",                        {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusolverDnXsytrs",                                   {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsytri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsytri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCsytri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZsytri_bufferSize",                        {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsytri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsytri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCsytri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZsytri",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgbr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgbr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungbr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungbr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgbr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgbr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungbr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungbr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsytrd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsytrd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChetrd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhetrd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChetrd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhetrd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSorgtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDorgtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCungtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZungtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSormtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDormtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCunmtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZunmtr_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSormtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDormtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCunmtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZunmtr",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvdx_bufferSize",                       {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvdx",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvd_bufferSize",                        {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvd",                                   {CUDA_80,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCreateSyevjInfo",                          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDestroySyevjInfo",                         {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevjSetTolerance",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevjSetMaxSweeps",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevjSetSortEig",                         {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevjGetResidual",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevjGetSweeps",                          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevjBatched_bufferSize",                 {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevjBatched_bufferSize",                 {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevjBatched_bufferSize",                 {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevjBatched_bufferSize",                 {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevjBatched",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevjBatched",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevjBatched",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevjBatched",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsyevj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsyevj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCheevj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZheevj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvj_bufferSize",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSsygvj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDsygvj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnChegvj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZhegvj",                                   {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCreateGesvdjInfo",                         {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDestroyGesvdjInfo",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdjSetTolerance",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdjSetMaxSweeps",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdjSetSortEig",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdjGetResidual",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdjGetSweeps",                         {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdjBatched_bufferSize",                {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdjBatched_bufferSize",                {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdjBatched_bufferSize",                {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdjBatched_bufferSize",                {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdjBatched",                           {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdjBatched",                           {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdjBatched",                           {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdjBatched",                           {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdj_bufferSize",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdj_bufferSize",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdj_bufferSize",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdj_bufferSize",                       {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdj",                                  {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdj",                                  {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdj",                                  {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdj",                                  {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdaStridedBatched_bufferSize",         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdaStridedBatched_bufferSize",         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdaStridedBatched_bufferSize",         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdaStridedBatched_bufferSize",         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnSgesvdaStridedBatched",                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnDgesvdaStridedBatched",                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnCgesvdaStridedBatched",                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnZgesvdaStridedBatched",                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverDnPotrf_bufferSize",                         {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnPotrf",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnPotrs",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGeqrf_bufferSize",                         {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGeqrf",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGetrf_bufferSize",                         {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGetrf",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGetrs",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnSyevd_bufferSize",                         {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnSyevd",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnSyevdx_bufferSize",                        {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnSyevdx",                                   {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGesvd_bufferSize",                         {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnGesvd",                                    {CUDA_110, CUDA_111, CUDA_0  }},
  {"cusolverDnXpotrf_bufferSize",                        {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXpotrf",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXpotrs",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgeqrf_bufferSize",                        {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgeqrf",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevd_bufferSize",                        {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevd",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevdx_bufferSize",                       {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXsyevdx",                                  {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvd_bufferSize",                        {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvd",                                   {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdp_bufferSize",                       {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdp",                                  {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdr_bufferSize",                       {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgesvdr",                                  {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerSetCallback",                        {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerSetFile",                            {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerOpenFile",                           {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerSetLevel",                           {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerSetMask",                            {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverDnLoggerForceDisable",                       {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusolverMgCreate",                                   {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgDestroy",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgDeviceSelect",                             {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgCreateDeviceGrid",                         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgDestroyGrid",                              {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgCreateMatrixDesc",                         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgSyevd_bufferSize",                         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgSyevd",                                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusolverMgGetrf_bufferSize",                         {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverMgGetrf",                                    {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverMgGetrs_bufferSize",                         {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverMgGetrs",                                    {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotrf_bufferSize",                         {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotrf",                                    {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotrs_bufferSize",                         {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotrs",                                    {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotri_bufferSize",                         {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverMgPotri",                                    {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrsymmdqHost",                           {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrsymamdHost",                           {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrmetisndHost",                          {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrzfdHost",                              {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrzfdHost",                              {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrzfdHost",                              {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrzfdHost",                              {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCreateCsrluInfoHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDestroyCsrluInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrluAnalysisHost",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrluBufferInfoHost",                     {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrluBufferInfoHost",                     {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrluBufferInfoHost",                     {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrluBufferInfoHost",                     {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrluFactorHost",                         {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrluFactorHost",                         {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrluFactorHost",                         {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrluFactorHost",                         {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrluZeroPivotHost",                      {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrluZeroPivotHost",                      {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrluZeroPivotHost",                      {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrluZeroPivotHost",                      {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrluSolveHost",                          {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrluSolveHost",                          {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrluSolveHost",                          {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrluSolveHost",                          {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpXcsrluNnzHost",                            {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrluExtractHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrluExtractHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrluExtractHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrluExtractHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCreateCsrqrInfoHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDestroyCsrqrInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrqrAnalysisHost",                       {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrBufferInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrBufferInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrBufferInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrBufferInfoHost",                     {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrSetupHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrSetupHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrSetupHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrSetupHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrFactorHost",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrFactorHost",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrFactorHost",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrFactorHost",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrZeroPivotHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrZeroPivotHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrZeroPivotHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrZeroPivotHost",                      {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrSolveHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrSolveHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrSolveHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrSolveHost",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrqrAnalysis",                           {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrBufferInfo",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrBufferInfo",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrBufferInfo",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrBufferInfo",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrSetup",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrSetup",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrSetup",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrSetup",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrFactor",                             {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrFactor",                             {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrFactor",                             {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrFactor",                             {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrZeroPivot",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrZeroPivot",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrZeroPivot",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrZeroPivot",                          {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpScsrqrSolve",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDcsrqrSolve",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCcsrqrSolve",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpZcsrqrSolve",                              {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpCreateCsrcholInfoHost",                    {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpDestroyCsrcholInfoHost",                   {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusolverSpXcsrcholAnalysisHost",                     {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholBufferInfoHost",                   {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholBufferInfoHost",                   {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholBufferInfoHost",                   {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholBufferInfoHost",                   {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholFactorHost",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholFactorHost",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholFactorHost",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholFactorHost",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholZeroPivotHost",                    {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholZeroPivotHost",                    {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholZeroPivotHost",                    {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholZeroPivotHost",                    {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholSolveHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholSolveHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholSolveHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholSolveHost",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCreateCsrcholInfo",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDestroyCsrcholInfo",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpXcsrcholAnalysis",                         {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholBufferInfo",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholBufferInfo",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholBufferInfo",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholBufferInfo",                       {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholFactor",                           {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholFactor",                           {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholFactor",                           {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholFactor",                           {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholZeroPivot",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholZeroPivot",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholZeroPivot",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholZeroPivot",                        {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholSolve",                            {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpDcsrcholSolve",                            {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpCcsrcholSolve",                            {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpZcsrcholSolve",                            {CUDA_75,  CUDA_128, CUDA_0  }},
  {"cusolverSpScsrcholDiag",                             {CUDA_101, CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 10200
  {"cusolverSpDcsrcholDiag",                             {CUDA_101, CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 10200
  {"cusolverSpCcsrcholDiag",                             {CUDA_101, CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 10200
  {"cusolverSpZcsrcholDiag",                             {CUDA_101, CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 10200
  {"cusolverDnXlarft",                                   {CUDA_124, CUDA_0,   CUDA_0  }},
  {"cusolverDnXlarft_bufferSize",                        {CUDA_124, CUDA_0,   CUDA_0  }},
  {"cusolverDnXgeev",                                    {CUDA_126, CUDA_0,   CUDA_0  }}, // CUSOLVER_VERSION 11701
  {"cusolverDnXgeev_bufferSize",                         {CUDA_126, CUDA_0,   CUDA_0  }}, // CUSOLVER_VERSION 11701
  {"cusolverDnXsyevBatched",                             {CUDA_126, CUDA_0,   CUDA_0  }}, // CUSOLVER_VERSION 11701
  {"cusolverDnXsyevBatched_bufferSize",                  {CUDA_126, CUDA_0,   CUDA_0  }}, // CUSOLVER_VERSION 11701
  {"cusolverRfSetupHost",                                {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfSetupDevice",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfResetValues",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfAnalyze",                                  {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfRefactor",                                 {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfAccessBundledFactorsDevice",               {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfExtractBundledFactorsHost",                {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfExtractSplitFactorsHost",                  {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverRfSolve",                                    {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpScsrlsvluHost",                            {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpDcsrlsvluHost",                            {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpCcsrlsvluHost",                            {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpZcsrlsvluHost",                            {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpScsrlsvcholHost",                          {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpDcsrlsvcholHost",                          {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpCcsrlsvcholHost",                          {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpZcsrlsvcholHost",                          {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpScsrlsvchol",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpDcsrlsvchol",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpCcsrlsvchol",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
  {"cusolverSpZcsrlsvchol",                              {CUDA_0,   CUDA_128, CUDA_0  }}, // CUSOLVER_VERSION 11702
};

const std::map<llvm::StringRef, hipAPIversions> HIP_SOLVER_FUNCTION_VER_MAP {
  {"hipsolverDnCreate",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDestroy",                                 {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgetrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgetrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgetrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgetrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgetrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgetrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgetrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgetrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgetrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgetrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgetrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgetrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverSetStream",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsolverGetStream",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsolverDnZZgesv",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCCgesv",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDDgesv",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSSgesv",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZZgesv_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCCgesv_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDDgesv_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSSgesv_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZZgels",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCCgels",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDDgels",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSSgels",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZZgels_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCCgels_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDDgels_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSSgels_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotrs",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotrfBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotrfBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotrfBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotrfBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotrsBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotrsBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotrsBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotrsBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotri_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotri_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotri_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotri_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSpotri",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDpotri",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCpotri",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZpotri",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgeqrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgeqrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgeqrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgeqrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgeqrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgeqrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgeqrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgeqrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSormqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDormqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCunmqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZunmqr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSormqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDormqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCunmqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZunmqr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsytrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsytrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCsytrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZsytrf_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsytrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsytrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCsytrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZsytrf",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgebrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgebrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgebrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgebrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgebrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgebrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgebrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgebrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgbr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgbr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungbr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungbr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgbr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgbr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungbr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungbr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsytrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsytrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChetrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhetrd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsytrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsytrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChetrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhetrd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSorgtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDorgtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCungtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZungtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSormtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDormtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCunmtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZunmtr_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSormtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDormtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCunmtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZunmtr",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvdx_bufferSize",                      {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvdx",                                 {HIP_5030, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvd_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvd",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCreateSyevjInfo",                         {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDestroySyevjInfo",                        {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXsyevjSetTolerance",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXsyevjSetMaxSweeps",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXsyevjSetSortEig",                        {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXsyevjGetResidual",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXsyevjGetSweeps",                         {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevjBatched_bufferSize",                {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevjBatched_bufferSize",                {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevjBatched_bufferSize",                {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevjBatched_bufferSize",                {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevjBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevjBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevjBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevjBatched",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsyevj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsyevj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCheevj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZheevj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvj_bufferSize",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSsygvj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDsygvj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnChegvj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZhegvj",                                  {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCreateGesvdjInfo",                        {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDestroyGesvdjInfo",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXgesvdjSetTolerance",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXgesvdjSetMaxSweeps",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXgesvdjSetSortEig",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXgesvdjGetResidual",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnXgesvdjGetSweeps",                        {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdjBatched_bufferSize",               {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdjBatched_bufferSize",               {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdjBatched_bufferSize",               {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdjBatched_bufferSize",               {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdjBatched",                          {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdjBatched",                          {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdjBatched",                          {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdjBatched",                          {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdj_bufferSize",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdj_bufferSize",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdj_bufferSize",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdj_bufferSize",                      {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdj",                                 {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdj",                                 {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdj",                                 {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdj",                                 {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdaStridedBatched_bufferSize",        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdaStridedBatched_bufferSize",        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdaStridedBatched_bufferSize",        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdaStridedBatched_bufferSize",        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnSgesvdaStridedBatched",                   {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnDgesvdaStridedBatched",                   {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnCgesvdaStridedBatched",                   {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverDnZgesvdaStridedBatched",                   {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsolverRfCreate",                                  {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfDestroy",                                 {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfGetMatrixFormat",                         {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetMatrixFormat",                         {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetNumericProperties",                    {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfGetNumericProperties",                    {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfGetNumericBoostReport",                   {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetAlgs",                                 {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfGetResetValuesFastMode",                  {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetResetValuesFastMode",                  {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetupHost",                               {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSetupDevice",                             {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfResetValues",                             {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfAnalyze",                                 {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfRefactor",                                {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfAccessBundledFactorsDevice",              {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfExtractBundledFactorsHost",               {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfExtractSplitFactorsHost",                 {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfSolve",                                   {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchSetupHost",                          {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchResetValues",                        {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchAnalyze",                            {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchRefactor",                           {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchSolve",                              {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverRfBatchZeroPivot",                          {HIP_5060, HIP_0,    HIP_0   }},
  {"hipsolverSpCreate",                                  {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpDestroy",                                 {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpSetStream",                               {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpScsrlsvchol",                             {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpDcsrlsvchol",                             {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpScsrlsvcholHost",                         {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverSpDcsrlsvcholHost",                         {HIP_6010, HIP_0,    HIP_0   }},
  {"hipsolverDnCreateParams",                            {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnDestroyParams",                           {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnSetAdvOptions",                           {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnXgetrf",                                  {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnXgetrf_bufferSize",                       {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnXgetrs",                                  {HIP_6020, HIP_0,    HIP_0   }},
  {"hipsolverDnSetDeterministicMode",                    {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnGetDeterministicMode",                    {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnXgeqrf_bufferSize",                       {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnXgeqrf",                                  {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnXpotrf_bufferSize",                       {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnXpotrf",                                  {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverDnXpotrs",                                  {HIP_6030, HIP_0,    HIP_0   }},
  {"hipsolverSpScsrlsvqr",                               {HIP_6040, HIP_0,    HIP_0   }},
  {"hipsolverSpDcsrlsvqr",                               {HIP_6040, HIP_0,    HIP_0   }},
  {"hipsolverSpCcsrlsvqr",                               {HIP_7000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsolverSpZcsrlsvqr",                               {HIP_7000, HIP_0,    HIP_0,  HIP_LATEST}},

  {"rocsolver_spotrf",                                   {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsolver_dpotrf",                                   {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsolver_cpotrf",                                   {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsolver_zpotrf",                                   {HIP_3060, HIP_0,    HIP_0   }},
};

const std::map<unsigned int, llvm::StringRef> CUDA_SOLVER_API_SECTION_MAP {
  {1, "CUSOLVER Data types"},
  {2, "CUSOLVER Function Reference"},
};
