; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes='default<O3>,print<scalar-evolution>' -disable-output -S < %s 2>&1 | FileCheck %s

target datalayout = "e-m:m-p:40:64:64:32-i32:32-i16:16-i8:8-n32"

;
; This file contains phase ordering tests for scalar evolution.
; Test that the standard passes don't obfuscate the IR so scalar evolution can't
; recognize expressions.

; The loop body contains two increments by %div.
; Make sure that 2*%div is recognizable, and not expressed as a bit mask of %d.
define void @test1(i32 %d, ptr %p) nounwind uwtable ssp {
; CHECK-LABEL: 'test1'
; CHECK-NEXT:  Classifying expressions for: @test1
; CHECK-NEXT:    %div1 = lshr i32 %d, 2
; CHECK-NEXT:    --> (%d /u 4) U: [0,1073741824) S: [0,1073741824)
; CHECK-NEXT:    %i.03 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,64) S: [0,64) Exits: 63 LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %p.addr.02 = phi ptr [ %p, %entry ], [ %add.ptr1, %for.body ]
; CHECK-NEXT:    --> {%p,+,(8 * (%d /u 4))}<%for.body> U: full-set S: full-set Exits: ((504 * (%d /u 4)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %add.ptr = getelementptr inbounds i32, ptr %p.addr.02, i32 %div1
; CHECK-NEXT:    --> {((4 * (%d /u 4))<nuw><nsw> + %p),+,(8 * (%d /u 4))}<%for.body> U: full-set S: full-set Exits: ((508 * (%d /u 4)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %add.ptr1 = getelementptr inbounds i32, ptr %add.ptr, i32 %div1
; CHECK-NEXT:    --> {((8 * (%d /u 4)) + %p),+,(8 * (%d /u 4))}<%for.body> U: full-set S: full-set Exits: ((512 * (%d /u 4)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.03, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,65) S: [1,65) Exits: 64 LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test1
; CHECK-NEXT:  Loop %for.body: backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: Trip multiple is 64
;
entry:
  %div = udiv i32 %d, 4
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %p.addr.0 = phi ptr [ %p, %entry ], [ %add.ptr1, %for.inc ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.inc ]
  %cmp = icmp ne i32 %i.0, 64
  br i1 %cmp, label %for.body, label %for.end

for.body:                                         ; preds = %for.cond
  store i32 0, ptr %p.addr.0, align 4
  %add.ptr = getelementptr inbounds i32, ptr %p.addr.0, i32 %div
  store i32 1, ptr %add.ptr, align 4
  %add.ptr1 = getelementptr inbounds i32, ptr %add.ptr, i32 %div
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %inc = add i32 %i.0, 1
  br label %for.cond

for.end:                                          ; preds = %for.cond
  ret void
}

; Same thing as test1, but it is even more tempting to fold 2 * (%d /u 2)
define void @test1a(i32 %d, ptr %p) nounwind uwtable ssp {
; CHECK-LABEL: 'test1a'
; CHECK-NEXT:  Classifying expressions for: @test1a
; CHECK-NEXT:    %div1 = lshr i32 %d, 1
; CHECK-NEXT:    --> (%d /u 2) U: [0,-2147483648) S: [0,-2147483648)
; CHECK-NEXT:    %i.03 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,64) S: [0,64) Exits: 63 LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %p.addr.02 = phi ptr [ %p, %entry ], [ %add.ptr1, %for.body ]
; CHECK-NEXT:    --> {%p,+,(8 * (%d /u 2))}<%for.body> U: full-set S: full-set Exits: ((504 * (%d /u 2)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %add.ptr = getelementptr inbounds i32, ptr %p.addr.02, i32 %div1
; CHECK-NEXT:    --> {((4 * (%d /u 2))<nuw><nsw> + %p),+,(8 * (%d /u 2))}<%for.body> U: full-set S: full-set Exits: ((508 * (%d /u 2)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %add.ptr1 = getelementptr inbounds i32, ptr %add.ptr, i32 %div1
; CHECK-NEXT:    --> {((8 * (%d /u 2)) + %p),+,(8 * (%d /u 2))}<%for.body> U: full-set S: full-set Exits: ((512 * (%d /u 2)) + %p) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.03, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,65) S: [1,65) Exits: 64 LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test1a
; CHECK-NEXT:  Loop %for.body: backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is i32 63
; CHECK-NEXT:  Loop %for.body: Trip multiple is 64
;
entry:
  %div = udiv i32 %d, 2
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %p.addr.0 = phi ptr [ %p, %entry ], [ %add.ptr1, %for.inc ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.inc ]
  %cmp = icmp ne i32 %i.0, 64
  br i1 %cmp, label %for.body, label %for.end

for.body:                                         ; preds = %for.cond
  store i32 0, ptr %p.addr.0, align 4
  %add.ptr = getelementptr inbounds i32, ptr %p.addr.0, i32 %div
  store i32 1, ptr %add.ptr, align 4
  %add.ptr1 = getelementptr inbounds i32, ptr %add.ptr, i32 %div
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %inc = add i32 %i.0, 1
  br label %for.cond

for.end:                                          ; preds = %for.cond
  ret void
}

@array = weak global [101 x i32] zeroinitializer, align 32		; <ptr> [#uses=1]


define void @test_range_ref1a(i32 %x) {
; CHECK-LABEL: 'test_range_ref1a'
; CHECK-NEXT:  Classifying expressions for: @test_range_ref1a
; CHECK-NEXT:    %i.01.0 = phi i32 [ 100, %entry ], [ %tmp4, %bb ]
; CHECK-NEXT:    --> {100,+,-1}<nsw><%bb> U: [0,101) S: [0,101) Exits: 0 LoopDispositions: { %bb: Computable }
; CHECK-NEXT:    %tmp1 = getelementptr [101 x i32], ptr @array, i32 0, i32 %i.01.0
; CHECK-NEXT:    --> {(400 + @array),+,-4}<nw><%bb> U: [0,-3) S: [-2147483648,2147483645) Exits: @array LoopDispositions: { %bb: Computable }
; CHECK-NEXT:    %tmp4 = add nsw i32 %i.01.0, -1
; CHECK-NEXT:    --> {99,+,-1}<nsw><%bb> U: [-1,100) S: [-1,100) Exits: -1 LoopDispositions: { %bb: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_range_ref1a
; CHECK-NEXT:  Loop %bb: backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb: constant max backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb: symbolic max backedge-taken count is i32 100
; CHECK-NEXT:  Loop %bb: Trip multiple is 101
;
entry:
	br label %bb

bb:		; preds = %bb, %entry
	%i.01.0 = phi i32 [ 100, %entry ], [ %tmp4, %bb ]		; <i32> [#uses=2]
	%tmp1 = getelementptr [101 x i32], ptr @array, i32 0, i32 %i.01.0		; <ptr> [#uses=1]
	store i32 %x, ptr %tmp1
	%tmp4 = add i32 %i.01.0, -1		; <i32> [#uses=2]
	%tmp7 = icmp sgt i32 %tmp4, -1		; <i1> [#uses=1]
	br i1 %tmp7, label %bb, label %return

return:		; preds = %bb
	ret void
}

define i32 @test_loop_idiom_recogize(i32 %x, i32 %y, ptr %lam, ptr %alp) nounwind {
; CHECK-LABEL: 'test_loop_idiom_recogize'
; CHECK-NEXT:  Classifying expressions for: @test_loop_idiom_recogize
; CHECK-NEXT:    %indvar = phi i32 [ 0, %bb1.thread ], [ %indvar.next, %bb1 ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%bb1> U: [0,256) S: [0,256) Exits: 255 LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %i.0.reg2mem.0 = sub nuw nsw i32 255, %indvar
; CHECK-NEXT:    --> {255,+,-1}<nsw><%bb1> U: [0,256) S: [0,256) Exits: 0 LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %0 = getelementptr i32, ptr %alp, i32 %i.0.reg2mem.0
; CHECK-NEXT:    --> {(1020 + %alp),+,-4}<nw><%bb1> U: full-set S: full-set Exits: %alp LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %1 = load i32, ptr %0, align 4
; CHECK-NEXT:    --> %1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %bb1: Variant }
; CHECK-NEXT:    %2 = getelementptr i32, ptr %lam, i32 %i.0.reg2mem.0
; CHECK-NEXT:    --> {(1020 + %lam),+,-4}<nw><%bb1> U: full-set S: full-set Exits: %lam LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %indvar.next = add nuw nsw i32 %indvar, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%bb1> U: [1,257) S: [1,257) Exits: 256 LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %tmp10 = mul i32 %x, 255
; CHECK-NEXT:    --> (255 * %x) U: full-set S: full-set
; CHECK-NEXT:    %z.0.reg2mem.0 = add i32 %y, %x
; CHECK-NEXT:    --> (%x + %y) U: full-set S: full-set
; CHECK-NEXT:    %3 = add i32 %z.0.reg2mem.0, %tmp10
; CHECK-NEXT:    --> ((256 * %x) + %y) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test_loop_idiom_recogize
; CHECK-NEXT:  Loop %bb1: backedge-taken count is i32 255
; CHECK-NEXT:  Loop %bb1: constant max backedge-taken count is i32 255
; CHECK-NEXT:  Loop %bb1: symbolic max backedge-taken count is i32 255
; CHECK-NEXT:  Loop %bb1: Trip multiple is 256
;
bb1.thread:
	br label %bb1

bb1:		; preds = %bb1, %bb1.thread
	%indvar = phi i32 [ 0, %bb1.thread ], [ %indvar.next, %bb1 ]		; <i32> [#uses=4]
	%i.0.reg2mem.0 = sub i32 255, %indvar		; <i32> [#uses=2]
	%0 = getelementptr i32, ptr %alp, i32 %i.0.reg2mem.0		; <ptr> [#uses=1]
	%1 = load i32, ptr %0, align 4		; <i32> [#uses=1]
	%2 = getelementptr i32, ptr %lam, i32 %i.0.reg2mem.0		; <ptr> [#uses=1]
	store i32 %1, ptr %2, align 4
	%3 = sub i32 254, %indvar		; <i32> [#uses=1]
	%4 = icmp slt i32 %3, 0		; <i1> [#uses=1]
	%indvar.next = add i32 %indvar, 1		; <i32> [#uses=1]
	br i1 %4, label %bb2, label %bb1

bb2:		; preds = %bb1
	%tmp10 = mul i32 %indvar, %x		; <i32> [#uses=1]
	%z.0.reg2mem.0 = add i32 %tmp10, %y		; <i32> [#uses=1]
	%5 = add i32 %z.0.reg2mem.0, %x		; <i32> [#uses=1]
	ret i32 %5
}

declare void @use(i1)

declare void @llvm.experimental.guard(i1, ...)

; This tests getRangeRef acts as intended with different idx size.
define void @test_range_ref1(i8 %t) {
; CHECK-LABEL: 'test_range_ref1'
; CHECK-NEXT:  Classifying expressions for: @test_range_ref1
; CHECK-NEXT:    %0 = zext i8 %t to i40
; CHECK-NEXT:    --> (zext i8 %t to i40) U: [0,256) S: [0,256)
; CHECK-NEXT:    %t.ptr = inttoptr i40 %0 to ptr
; CHECK-NEXT:    --> %t.ptr U: [0,256) S: [0,256)
; CHECK-NEXT:    %idx = phi ptr [ %t.ptr, %entry ], [ %snext, %loop ]
; CHECK-NEXT:    --> {%t.ptr,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %snext = getelementptr inbounds i8, ptr %idx, i32 1
; CHECK-NEXT:    --> {(1 + %t.ptr)<nuw><nsw>,+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_range_ref1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  %t.ptr = inttoptr i8 %t to ptr
  %p.42 = inttoptr i8 42 to ptr
  %cmp1 = icmp slt ptr %t.ptr, %p.42
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp1) [ "deopt"() ]
  br label %loop

 loop:
  %idx = phi ptr [ %t.ptr, %entry ], [ %snext, %loop ]
  %snext = getelementptr inbounds i8, ptr %idx, i64 1
  %c = icmp slt ptr %idx, %p.42
  call void @use(i1 %c)
  %be = icmp slt ptr %snext, %p.42
  br i1 %be, label %loop, label %exit

 exit:
  ret void
}

