use strict;
use warnings;

use RT::Test tests => undef;

plan skip_all => 'GraphViz required.'
    unless RT::StaticUtil::RequireModule("GraphViz2");

my ($base, $m) = RT::Test->started_ok;
$m->login;

for my $arg (qw(LeadingLink ShowLinks)) {
    my $ticket = RT::Test->create_ticket(
        Queue   => 'General',
        Subject => 'testing',
    );
    ok $ticket->id, 'created ticket';

    ok !$ticket->ToldObj->IsSet, 'no Told';
    $m->get_ok("$base/Ticket/Graphs/index.html?$arg=SetTold;id=" . $ticket->id);

    $ticket->Load($ticket->id); # cache busting

    ok !$ticket->ToldObj->IsSet, 'still no Told';
    $m->content_lacks('GotoFirstItem', 'no GotoFirstItem error');
    $m->content_like(qr|<svg.+?<a xlink:href=['"]/Ticket/Display\.html\?id=@{[$ticket->id]}|s, 'found image element');
}

done_testing;
